#ifdef CShield_EXPORTS
#define CShield_API __declspec(dllexport)
#else
#define CShield_API __declspec(dllimport)
#endif

typedef struct _CShieldData {
	DWORD dwThreadId;
	HANDLE hThread;
	DWORD dwStartAddress;
	DWORD dwUser32Low;
	DWORD dwUser32Hi;
	DWORD dwMemType;
	DWORD dwMemAllocationBase;
} CShieldData;

extern CShieldData myCShieldData;

CShield_API CShieldData InitializeCShield(const std::string address, const std::string port, const unsigned long paddingBytes = 16);
CShield_API bool CheckAttackspeed(float attackSpeed, float range, bool twoHanded, bool twoHandedHorse);
CShield_API bool CheckMovespeed(float moveSpeed);
CShield_API bool CheckValues();
CShield_API bool CheckValuesCython();
CShield_API bool CheckMove(bool active, bool mov, float xPos, float yPos);
CShield_API std::string GenKey(bool isGamePhase, DWORD num);
CShield_API std::string GetCShieldLoginKey(const char* name);
CShield_API std::string GetCShieldCaptcha(const char* captcha);
extern CShield_API DWORD clientCode;
extern CShield_API char charName[24];
